clear all

* Set Folder to input one

cd ..\Inputs

* Import GDP data
import excel "GDPC96.xls", sheet("FRED Graph") cellrange(B11) firstrow clear
save GDPC96, replace

* Import GDP Deflator data
import excel "GDPDEF.xls", sheet("FRED Graph") cellrange(B11) firstrow clear
save GDPDEF, replace

* Import FFR data
import excel "FEDFUNDS.xls", sheet("FRED Graph") cellrange(B11) firstrow clear
gen     quarter=1 if month==1  | month==2  | month==3
replace quarter=2 if month==4  | month==5  | month==6
replace quarter=3 if month==7  | month==8  | month==9
replace quarter=4 if month==10 | month==11 | month==12

rename FED ffr
collapse (mean) ffr, by(year quarter)
label var ffr "Effective federal funds rate"
save FEDFUNDS, replace

use GDPC96, clear
joinby year quarter using GDPDEF
joinby year quarter using FEDFUNDS, unmatched(master)
tab _merge
drop _merge

sort year quarter
gen t=_n
tsset t

gen time=year+(q-1)/4

gen lnY=log(GDPC96)
gen dlogP=log(GDPDEF/l.GDPDEF)

reg ffr l(1/4).ffr l(0/4).lnY l(0/4).dlogP if year<=2008
predict MPVAR0, resid

reg ffr l(1/4).ffr l(0/4).lnY l(0/4).dlogP 
predict MPVAR1, resid

keep year quarter MPVAR*

* Change to output folder and save

cd ..\Outputs
save shocks_MPVAR, replace

* Chnage back to input folder and delete temporary databases

cd ..\Inputs

erase GDPDEF.dta
erase FEDFUNDS.dta
